******************************************************
* FIRMWARE.SRC                                       *
******************************************************
DUART    EQU      $C001    ;68681 base address
MR1A     EQU      0*2      ;mode reg. 1A
MR2A     EQU      0*2      ;mode reg. 2A
CSRA     EQU      1*2      ;clock select reg. A
SRA      EQU      1*2      ;status register A
CRA      EQU      2*2      ;command reg. A
TBA      EQU      3*2      ;Tx buffer A
CR       EQU      $0D      ;ASCII carriage return
LF       EQU      $0A      ;ASCII line feed
B9600    EQU      $BB      ;9600 buad

         ORG      0
FIRMWARE BSR.S    INIT            ;init 68681 DUART
         MOVE.W   #9,D7           ;use D7 as counter
LOOP     LEA      TEXT(PC),A1     ;A1 ---> message
         BSR.S    OUTSTR          ;send it
         DBRA     D7,LOOP         ;repeat until done
         BRA      *               ;infinite loop

******************************************************
* OUTCHR - OUTput CHaRacter in D0 to serial port     *
******************************************************
OUTCHR   MOVE.L   A0,-(A7)       ;save A0
         MOVE.W   D7,-(A7)       ;save D7
         MOVEA.L  #DUART,A0      ;A0 points to 68681
OUTCHR2  MOVE.B   SRA(A0),D7     ;get port A status
         ANDI.B   #4,D7          ;buffer empty?
         BEQ.S    OUTCHR2        ;no:  check again
         MOVE.B   D0,TBA(A0)     ;yes: send char.
         MOVE.W   (A7)+,D7       ;restore D7
         MOVE.L   (A7)+,A0       ;restore A0
         RTS

******************************************************
* OUTSTR - OUTput null-terminated STRing             *
******************************************************
OUTSTR   MOVE.L   D0,-(A7)       ;save D0 on stack
OUTSTR2  MOVE.B   (A1)+,D0       ;get character
         BEQ.S    EXIT           ;if null byte, done
         BSR.S    OUTCHR         ;send it
         BRA.S    OUTSTR2        ;repeat
EXIT     MOVE.L   (A7)+,D0       ;restore D0
         RTS

******************************************************
* INIT   INITialize 68681 DUART channel A            *
******************************************************
INIT     MOVEA.L  #DUART,A0       ;A0 points to DUART
         MOVE.B   #$06,MR1A(A0)   ;7 data, odd parity
         MOVE.B   #$0F,MR2A(A0)   ;2 stop bits (Tx)
         MOVE.B   #B9600,CSRA(A0) ;set baud rate
         MOVE.B   #$05,CRA(A0)    ;Tx/Rx enabled
         RTS

TEXT     DC.B     CR,LF,'Test firmware program',0
         END      FIRMWARE
